### 59.5. 就地（in-place）运行项目

为了在不先构建jar的情况下运行项目，你可以使用"bootRun"任务：
```shell
$ gradle bootRun
```
默认情况下，以这种方式运行项目可以让你的静态classpath资源（比如，默认位于`src/main/resources`下）在应用运行期间被重新加载。使静态资源可以重新加载意味着`bootRun`任务不会使用`processResources`任务的输出，比如，当调用`bootRun`时，你的应用将以资源未处理的形式来使用它们。

你可以禁止直接使用静态classpath资源。这意味着资源不再是可重新加载的，但`processResources`任务的输出将会被使用。想要这样做，只需将`bootRun`任务的`addResources`设为false：
```gradle
bootRun {
    addResources = false
}
```
